/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.client.ISkillRenderer;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.skill.ISkill;
import dev.toma.gunsrpg.client.render.skill.SkillRendererRegistry;
import dev.toma.gunsrpg.client.screen.skill.IViewContext;
import dev.toma.gunsrpg.client.screen.widgets.IClickResponder;
import dev.toma.gunsrpg.common.skills.core.DisplayData;
import dev.toma.gunsrpg.common.skills.core.DisplayType;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.ITickable;
import dev.toma.gunsrpg.util.RenderUtils;
import dev.toma.gunsrpg.util.SkillUtil;
import dev.toma.gunsrpg.util.math.Mth;
import java.util.Objects;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.Easings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class SkillWidget
extends Widget
implements ITickable {
    public static final DisplayData UNKNOWN = DisplayData.create(DisplayType.ICON, GunsRPG.makeResource("textures/icons/unknown.png"));
    private final SkillType<?> source;
    private final IViewContext context;
    private final FontRenderer renderer;
    private final int tagSize;
    private final boolean invisible;
    private IClickResponder<SkillType<?>> responder = type -> {};
    private int lastAnimationTime;
    private int animationTime;
    private int glowTimer;

    public SkillWidget(int x, int y, int width, int height, SkillType<?> source, IViewContext context, boolean invisible) {
        super(x, y, width, height, StringTextComponent.field_240750_d_);
        this.source = source;
        this.context = context;
        this.renderer = Minecraft.func_71410_x().field_71466_p;
        this.tagSize = invisible ? this.renderer.func_78256_a("???") : this.renderer.func_238414_a_((ITextProperties)source.getTitle());
        this.invisible = invisible;
    }

    @Override
    public void tick() {
        this.lastAnimationTime = this.animationTime;
        this.animationTime = MathHelper.func_76125_a((int)(this.field_230692_n_ ? (this.animationTime = this.animationTime + 1) : (this.animationTime = this.animationTime - 1)), (int)0, (int)15);
        ++this.glowTimer;
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230692_n_) {
            this.source.acknowledge();
        }
        Matrix4f pose = matrix.func_227866_c_().func_227870_a_();
        ISkillProvider provider = this.context.getData().getSkillProvider();
        boolean unlocked = !this.invisible && provider.hasSkill(this.source);
        int primary = unlocked ? -16729344 : -13355980;
        int secondary = unlocked ? -16751104 : -14474461;
        this.renderBackgroundFrame(pose);
        RenderUtils.drawGradient(pose, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230690_l_ + this.field_230688_j_ - 1, this.field_230691_m_ + this.field_230689_k_ - 1, primary, secondary);
        DisplayData data = this.invisible ? UNKNOWN : this.source.getDisplayData();
        data.renderAt(matrix, this.field_230690_l_ + 3, this.field_230691_m_ + 3);
        this.renderExtraData(matrix, this.source, provider, partialTicks);
        this.renderHoverInfo(partialTicks, matrix, pose);
    }

    public void setClickResponder(IClickResponder<SkillType<?>> responder) {
        this.responder = Objects.requireNonNull(responder);
    }

    public void func_230982_a_(double p_230982_1_, double p_230982_3_) {
        this.responder.onElementClicked(this.source);
    }

    private void renderHoverInfo(float partialTicks, MatrixStack stack, Matrix4f pose) {
        float last;
        float current = this.getAnimationProgress(this.animationTime);
        float rawAnimationProgress = AnimationUtils.linearInterpolate(current, last = this.getAnimationProgress(this.lastAnimationTime), partialTicks);
        this.renderTagBackground(rawAnimationProgress < 0.5f ? 0.0f : (rawAnimationProgress < 0.9f ? (rawAnimationProgress - 0.5f) / 0.4f : 1.0f), pose);
        this.renderTag(rawAnimationProgress < 0.8f ? 0.0f : (rawAnimationProgress - 0.8f) / 0.2f, stack);
    }

    private void renderTagBackground(float raw, Matrix4f pose) {
        float f = Easings.EASE_OUT_SINE.ease(raw);
        float center = this.getComponentCenter();
        float tagHalfWidth = 2.0f + (float)this.tagSize / 2.0f;
        float left = center - tagHalfWidth * f;
        float right = center + tagHalfWidth * f;
        float y = this.field_230691_m_ + this.field_230689_k_ + 3;
        RenderUtils.drawSolid(pose, left, y, right, y + 13.0f, 0x77000000);
    }

    private void renderTag(float raw, MatrixStack stack) {
        if (raw < 0.2f) {
            return;
        }
        int alpha = (int)(255.0f * raw);
        if (this.invisible) {
            this.renderer.func_238421_b_(stack, "???", this.getComponentCenter() - (float)this.tagSize / 2.0f, (float)(this.field_230691_m_ + this.field_230689_k_ + 6), alpha << 24 | 0xFFFFFF);
            return;
        }
        this.renderer.func_243248_b(stack, this.source.getTitle(), this.getComponentCenter() - (float)this.tagSize / 2.0f, (float)(this.field_230691_m_ + this.field_230689_k_ + 6), alpha << 24 | 0xFFFFFF);
    }

    private float getAnimationProgress(int value) {
        return (float)value / 15.0f;
    }

    private float getComponentCenter() {
        return (float)this.field_230690_l_ + (float)this.field_230688_j_ / 2.0f;
    }

    private void renderBackgroundFrame(Matrix4f pose) {
        int bgColor;
        if (!this.invisible && this.source.isFresh()) {
            int glowTime = this.glowTimer % 40;
            float raw = Mth.triangleFunc((float)glowTime / 40.0f);
            float eased = Easings.EASE_IN_OUT_QUAD.ease(raw);
            int saturation = (int)(255.0f * eased);
            bgColor = 0xFF000000 | saturation << 16 | saturation << 8;
        } else {
            bgColor = this.field_230692_n_ ? -1 : -16777216;
        }
        RenderUtils.drawSolid(pose, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, bgColor);
    }

    private <S extends ISkill> void renderExtraData(MatrixStack stack, SkillType<S> type, ISkillProvider provider, float partialTicks) {
        ISkillRenderer<S> renderer = SkillRendererRegistry.getRendererFor(type);
        if (this.invisible || renderer == null) {
            return;
        }
        S skill = SkillUtil.getTopHierarchySkill(type, provider);
        if (skill == null) {
            return;
        }
        if (skill.getType() != type) {
            return;
        }
        float raw = AnimationUtils.linearInterpolate(this.getAnimationProgress(this.animationTime), this.getAnimationProgress(this.lastAnimationTime), partialTicks);
        renderer.renderExtraSkillData(skill, stack, this.renderer, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, raw < 0.5f ? 1.0f - raw / 0.5f : 0.0f);
    }
}

